Write-Host "Running PowerShell shortcut creator..."

# Script folder
$ScriptFolder = Split-Path -Parent $MyInvocation.MyCommand.Definition
Write-Host "Script folder: $ScriptFolder"

# Go 1 folder up
$Base = Split-Path -Parent $ScriptFolder
Write-Host "Using base folder: $Base"


# Desktop path from registry
$desktopReg = (Get-ItemProperty 'HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders').'Desktop'
$Desktop = [Environment]::ExpandEnvironmentVariables($desktopReg)
Write-Host "Desktop: $Desktop"

# Icon cache
$IconCache = Join-Path $env:LOCALAPPDATA 'MiniBookIcons'
if (!(Test-Path $IconCache)) {
    New-Item -ItemType Directory -Path $IconCache | Out-Null
}
Write-Host "Icon cache: $IconCache"

# Scripts to process
$scripts = 'MiniBook','HamlibServer'

foreach ($s in $scripts) {

    Write-Host "----------------------------------------"
    Write-Host "Processing $s"

    $scriptPath = Join-Path $Base ($s + '.py')
    $iconSource = Join-Path $Base ($s + '.ico')
    $iconTarget = Join-Path $IconCache ($s + '.ico')

    Write-Host "Script path: $scriptPath"

    if (!(Test-Path $scriptPath)) {
        Write-Host "ERROR: Script missing!" -ForegroundColor Red
        continue
    }

    if (Test-Path $iconSource) {
        Copy-Item $iconSource $iconTarget -Force
        $useIcon = $iconTarget
        Write-Host "Icon: $useIcon"
    } else {
        $useIcon = $null
        Write-Host "No icon found. Using default."
    }

    $lnk = Join-Path $Desktop ($s + '.lnk')
    Write-Host "Creating shortcut: $lnk"

    $wsh = New-Object -ComObject WScript.Shell
    $shortcut = $wsh.CreateShortcut($lnk)
    $shortcut.TargetPath = 'pythonw.exe'
    $shortcut.Arguments = '"' + $scriptPath + '"'
    $shortcut.WorkingDirectory = $Base
    if ($useIcon) { $shortcut.IconLocation = $useIcon }
    $shortcut.Save()

    Write-Host "Shortcut created."
}

Write-Host "All operations completed."
